/*
 -------------------------------------------------------------------------------
 Beschreibung:
 Der PCF8574 hat eine whlbare 3-Bit Adresse. Bei der Adressierung darf kein
 Adresspin offen bleiben.
 -------------------------------------------------------------------------------
 Achtung, ganz wichtig:
 Die Ports mssen als Ausgang initialisiert werden bevor der IIC-Bus
 benutzt wird: I2C_Init(I2C_400kHz)
 Wenn Sie einen Portzustand lesen. ist wichtig, dass vorher der PCF8574
 initialisiert wurde (alle Ports die gelesen werden sollen Output HI),
 dann liegen alle Ports hochohmig auf HI und knnen LO gezogen werden.
 Ist ein Port auf LO geschaltet, knnen sie ihn nicht nach HI ziehen,
 Das ist deshalb so, weil der PCF 8574 kein Datenrichtungsregister hat,
 und die Ports (auch beim Lesen des Eingangswertes) immer als Ausgang
 geschaltet sind.
 -----------------------------------------------------------------------------*/
void PORTEXPANDER_INIT(void)            // Ausgnge auf HIGH => deaktiviert
{
    OUT1_8=255; OUT9_16=255; OUT17_24=255;
    TriacOUT1_8=255; TriacHeizung=255;
}
void PORTEXPANDER(void)
{
//------------------------- Eingnge abfragen ----------------------------------
// Porterweiterung ist LOW basierend, z. B.: Klingel gedrckt -> LOW am Eingang
// durch Invertierung ~ des Bytes wird  das Byte auf HIGH basierend gendert!
// Ausnahme Alarmanlage!!
  Alarmkontakte=PORTREAD(I2C_ADR_IN1_8,0xFF);   // Ergebnis = LOW aktiv
  IN9_16=~(PORTREAD(I2C_ADR_IN9_16,0xFF));      // Ergebnis wird von LOW aktiv
  IN17_24=~(PORTREAD(I2C_ADR_IN17_24,0xFF));    // auf HIGH aktiv invertiert
//---------- Ausgnge: Ausgnge werden nur bei nderungen aktuallisiert --------
  if (mOUT1_8!=OUT1_8)                  // Ausgnge nur bei nderung aktualisieren
  {
    PORTWRITE(I2C_ADR_OUT1_8,OUT1_8);   // Ausgnge ndern
    mOUT1_8=OUT1_8;
  }
  if (mOUT9_16!=OUT9_16)
  {
    PORTWRITE(I2C_ADR_OUT9_16,OUT9_16);
    mOUT9_16=OUT9_16;
  }
  if (mOUT17_24!=OUT17_24)
  {
    PORTWRITE(I2C_ADR_OUT17_24,OUT17_24);
    mOUT17_24=OUT17_24;
  }
  if (mTriacOUT1_8!=TriacOUT1_8)
  {
    PORTWRITE(I2C_ADR_TriacOUT1_8,TriacOUT1_8);
    mTriacOUT1_8=TriacOUT1_8;
  }
  if (mTriacHeizung!=TriacHeizung)
  {
    PORTWRITE(I2C_ADR_TriacHeizung,TriacHeizung);
    mTriacHeizung=TriacHeizung;
  }
}
byte PORTREAD(byte I2C_ADR, byte I2C_DATA)
{
  I2C_Start();
  I2C_Write(I2C_ADR);
  I2C_Write(I2C_DATA);
  I2C_Start();
  I2C_Write(I2C_ADR+1);
  I2C_DATA=(I2C_Read_NACK());
  I2C_Stop();
  return I2C_DATA;
}
void PORTWRITE(byte I2C_ADR, byte I2C_DATA)
{
  I2C_Start();
  I2C_Write(I2C_ADR);
  I2C_Write(I2C_DATA);
  I2C_Stop();
}

