/*** LCD_Command.h ***/
//------------------------------------------------
 #ifndef __LCD_COMMAND__
 #define __LCD_COMMAND__
//------------------------------------------------
/*** LCD-Instructions ***/
// Clear display
// Clears entire display and sets DDRAM address 0 in address counter.
 #define LCD_CLEAR          0x01

// Return home
// Sets DDRAM address 0 in address counter. Also returns display from
// being shifted to original position. DDRAM contents remain unchanged.
 #define LCD_RETURN         0x02

// Entry mode set
// Sets cursor move direction and specifies display shift. These operations
// are performed during data write and read.
 #define LCD_MODE           0x04
 #define CURSOR_MOVE_RIGHT  0x02
 #define CURSOR_MOVE_LEFT   0x00
 #define AUTO_SHIFT_ENABLE  0x01
 #define AUTO_SHIFT_DISABLE 0x00

// Display on/off control
// Sets entire display (D) on/off, cursor on/off (C), and blinking of cursor
// position character (B).
 #define LCD_CONTROL        0x08
 #define DISPLAY_ON         0x04
 #define DISPLAY_OFF        0x00
 #define CURSOR_ON          0x02
 #define CURSOR_OFF         0x00
 #define BLINKING_ON        0x01
 #define BLINKING_OFF       0x00

// Cursor or display shift
// Moves cursor and shifts display without changing DDRAM contents.
 #define LCD_SHIFT          0x10
 #define SHIFT_DISPLAY      0x08
 #define SHIFT_CURSOR       0x00
 #define SHIFT_RIGHT        0x04
 #define SHIFT_LEFT         0x00

// Function set
// Sets interface data length (DL), number of display lines (N),
// and character font (F).
 #define LCD_SET            0x20
 #define INTERFACE_8_BITS   0x10
 #define INTERFACE_4_BITS   0x00
 #define TWO_LINES          0x08
 #define ONE_LINE           0x00
 #define 5_X_10_DOTS        0x04
 #define 5_X_8_DOTS         0x00

// Set CGRAM address
// Sets CGRAM address. CGRAM data is sent and received after this setting.
 #define LCD_CGRAM          0x40

// Set DDRAM address
// Sets DDRAM address. DDRAM data is sent and received after this setting.
 #define LCD_DDRAM          0x80

 #define LCD_CMD_R_DATA     (LCD_READ|LCD_DATA_REG|LCD_DATA)
 #define LCD_START_DATA     (LCD_READ|LCD_DATA_REG|LCD_DATA|LCD_ENABLE)

 #define LCD_CMD_R_BUSY     (LCD_READ|LCD_DATA)
 #define LCD_START_BUSY     (LCD_READ|LCD_DATA|LCD_ENABLE)

//------------------------------------------------
 #endif
//------------------------------------------------