/*** WatchDog-0.02.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
/*** Define Watchdog Timer Prescaler ***/
// The theoretical values differs very strongly from the virtually measured.
// The first value is from the table, the second value is measured practical.
// The third value is the available time between the reset-calls.

 #define WDT_12_MS   0x00
// M32  16.3 | 11.096 | 11 ms
// M128 14.0 | 11.106 | 11 ms

 #define WDT_24_MS   0x01
// M32  32.5 | 23.120 | 23 ms
// M128 28.1 | 23.122 | 23 ms

 #define WDT_48_MS   0x02
// M32  65.0 | 48.136 | 48 ms
// M128 56.2 | 47.156 | 47 ms

 #define WDT_96_MS   0x03
// M32  130  | 96.200 | 96 ms
// M128 110  | 96.25  | 96 ms

 #define WDT_192_MS  0x04
// M32  260  | 193.33 | 193 ms
// M128 220  | 192.4  | 192 ms

 #define WDT_384_MS  0x05
// M32  520  | 386.58 | 386 ms
// M128 450  | 384.7  | 384 ms

 #define WDT_768_MS  0x06
// M32  1000 | 774.06 | 773 ms
// M128 900  | 770    | 769 ms

 #define WDT_1536_MS 0x07
// M32  2100 | 1548   | 1546 ms
// M128 1800 | 1541   | 1539 ms

//------------------------------------------------
/*** Declare ASM Functions ***/

// Set new prescaler, disable the watchdog timer and
// clear the watchdog reset flag.
// Should be called once at the beginning of the program.
 void WatchDogInit      $asm("TagWatchDogInit")    (byte by_prescaler);

// set new prescaler
// Can be called everywhere in the programm to set a new prescaler value.
 void WatchDogSetTime $asm("TagWatchDogSetTime")   (byte by_prescaler);

// enabled the time supervision
 void WatchDogStart   $asm("TagWatchDogStart")     (void);

// disabled the time supervision
 void WatchDogStop    $asm("TagWatchDogStop")      (void);

// This function must be called before the Watchdog-time elapses.
 void WatchDogReset   $asm("TagWatchDogReset")     (void);

// only for test and measurement purposes
// This function should NOT be called in a real program. 
 #ifdef MEGA32
 void WatchDogResetT  $asm("TagWatchDogResetT32")  (void);
 #elif MEGA128
 void WatchDogResetT  $asm("TagWatchDogResetT128") (void);
 #endif

// It doesn't work properly on Mega32! I don't know why?
// When the program on Mega32 starts again after a Watchdog-Reset,
// no Watchdog-Reset-Flag is set.
 #ifdef MEGA128
 byte WatchDogIsReset $asm("TagWatchDogIsReset") (void);
 #endif

// Clears the Watchdog Reset Flag in MCU Control and Status Register
 void WatchDogClear   $asm("TagWatchDogClear")   (void);

// get the content of the MCU Control and Status Register
 byte GetMCUCSR       $asm("TagGetMCUCSR")       (void);

//------------------------------------------------