#!/usr/bin/perl -w
#*** eeprom_table_generator.pl ***#
#------------------------------------------------
 use strict;
 use warnings;
 use 5.012;
#------------------------------------------------
 say('please enter number of fft points: ');
 chomp(my $fft_n = <STDIN>);

 say('please enter EEPROM start address: ');
 chomp(my $eeprom_start = <STDIN>);
#------------------------------------------------
 sub Line { return '//' . '-' x 48; }
#------------------------------------------------
 sub InsertCosSin
    {
    my @values = ();
    my $line = '    ';
    my $cos = 0;
    my $sin = 0;
    my $stp = $fft_n / 2;
    my $pi  = atan2(1, 1) * 4;

    for(my $point = 0; $point < $stp; $point++)
        {
        $sin = int(sin($point * $pi / $stp) * 32767);
        $cos = int(cos($point * $pi / $stp) * 32767);
        $line .= sprintf("%6d, %6d", $cos, $sin);
        $line .= ', ' if(($point + 1) < $stp);
        unless((1 + $point) % 16)
            {
            push(@values, $line);
            $line = '    ';
            }
        }
    return @values;
    }
#------------------------------------------------
 my @code = (
    '/*** WriteEEPROMTable.cc ***/',
    Line(),
    ' #define FFT_N ' . $fft_n,
    ' #define EEPROM_START_ADD ' . $eeprom_start,
    Line(),
    ' flash int gi_table[FFT_N] = ',
    '    {',
    InsertCosSin(),
    '    };',
    Line(),
    ' void main(void)',
    '    {',
    '    word w_address;',
    '    int i_index;',
    '',
    '    w_address = EEPROM_START_ADD;',
    '    for(i_index = 0; i_index < FFT_N; i_index++)',
    '        {',
    '        EEPROM_WriteWord(w_address, gi_table[i_index]);',
    '        w_address = w_address + 2;',
    '        }',
    '    }',
    Line()
    );

 open(my $code, '>', 'WriteEEPROMTable.cc') or die("error in open: $!\n");
 say($code $_) foreach(@code);
 close($code);
 say('end of program');
#------------------------------------------------