;*** ADCapture.asm ***;
;-------------------------------------------------
; Authors: Torsten Knorr, Pepe V??? create-soft@freenet.de
;*** BUGS ***;
; Maybe you'll find some. Please let me know.
; By the way I am pleased with every kind of feedback.
;-------------------------------------------------
;*** Register Definitions ***;
 .def R_DATA_LOW   = R0
 .def R_DATA_HIGH  = R1
 .def R_SP_LOW     = R6
 .def R_SP_HIGH    = R7
 .def R_PARAM_LOW  = R10
 .def R_PARAM_HIGH = R11
 .def R_TEMP_LOW   = R22
 .def R_TEMP_HIGH  = R23
 .def R_COUNT_LOW  = R24
 .def R_COUNT_HIGH = R25
 .def R_XP_LOW     = R26
 .def R_XP_HIGH    = R27
 .def R_ZP_LOW     = R30
 .def R_ZP_HIGH    = R31
;-------------------------------------------------
;*** ADMUX - ADC Multiplexer Selection Register ***;
 .equ ADMUX = 0x07
 .equ MUX0  = 0    ; Analog Channel and Gain Selection Bits
 .equ MUX1  = 1    ; Analog Channel and Gain Selection Bits
 .equ MUX2  = 2    ; Analog Channel and Gain Selection Bits
 .equ MUX3  = 3    ; Analog Channel and Gain Selection Bits
 .equ MUX4  = 4    ; Analog Channel and Gain Selection Bits
 .equ MUXM  = 0x1F ; Analog Channel and Gain Selection Mask
 .equ ADLAR = 5	   ; Left Adjust Result
 .equ REFS0 = 6	   ; Reference Selection Bit 0
 .equ REFS1 = 7    ; Reference Selection Bit 1
 .equ REFSM = 0xC0 ; Reference Selection Mask
;-------------------------------------------------
;*** ADCSRA - ADC Control and Status Register A ***;
 .equ ADCSRA = 0x06
 .equ ADCSR  = ADCSRA ; For compatibility
 .equ ADPS0  = 0      ; ADC Prescaler Select Bits
 .equ ADPS1  = 1      ; ADC Prescaler Select Bits
 .equ ADPS2  = 2      ; ADC Prescaler Select Bits
 .equ ADPSM  = 0x07   ; ADC Prescaler Select Mask
 .equ ADIE   = 3      ; ADC Interrupt Enable
 .equ ADIF   = 4      ; ADC Interrupt Flag
 .equ ADFR   = 5      ; ADC  Free Running Select
 .equ ADSC   = 6      ; ADC Start Conversion
 .equ ADEN   = 7      ; ADC Enable
;-------------------------------------------------
;*** ADCH - ADC Data Register High Byte ***;
 .equ ADCH  = 0x05
;-------------------------------------------------
;*** ADCL - ADC Data Register Low Byte ***;
 .equ ADCL  = 0x04
;-------------------------------------------------
;*** SREG - Status Register ***;
 .equ SREG  = 0x3F
;-------------------------------------------------
;*** MCUCR - MCU Control Register ***;
 .equ MCUCR = 0x35
 .equ IVCE  = 0    ; Interrupt Vector Change Enable
 .equ IVSEL = 1    ; Interrupt Vector Select
 .equ SM2   = 2    ; Sleep Mode Select
 .equ SM0   = 3    ; Sleep Mode Select
 .equ SM1   = 4    ; Sleep Mode Select
 .equ SE    = 5    ; Sleep Enable
 .equ SRW10 = 6    ; External SRAM Wait State Select
 .equ SRE   = 7    ; External SRAM Enable
;-------------------------------------------------
 .ifdef TagADCaptureSetVref
 ADCaptureSetVref:

; move parameter stack pointer into Z
    movw R_ZP_LOW,     R_PARAM_LOW

; load 1st parameter (by_vref) into R_TEMP_LOW
    ld   R_TEMP_LOW,   Z

; mask bits REFS0/REFS1
    andi R_TEMP_LOW,   REFSM

    cbi  ADMUX,        REFS0
    cbi  ADMUX,        REFS1
    in   R_TEMP_HIGH,  ADMUX
    or   R_TEMP_LOW,   R_TEMP_HIGH

    out  ADMUX,        R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureSetPrescaler
 ADCaptureSetPrescaler:

; move parameter stack pointer into Z
    movw R_ZP_LOW,     R_PARAM_LOW

; load 1st parameter (by_prescaler) into R_TEMP_LOW
    ld   R_TEMP_LOW,   Z

; mask bits ADPS0/ADPS1/ADPS2
    andi R_TEMP_LOW,   ADPSM

    in   R_TEMP_HIGH,  ADCSRA
    andi R_TEMP_HIGH,  ~ADPSM
    or   R_TEMP_LOW,   R_TEMP_HIGH

    out  ADCSRA,       R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureSetChannel
 ADCaptureSetChannel:

; move parameter stack pointer into Z
    movw R_ZP_LOW,     R_PARAM_LOW

; load 1st parameter (by_channel) into R_TEMP_LOW
    ld   R_TEMP_LOW,   Z

; mask bits MUX0/MUX1/MUX2/MUX3/MUX4
    andi R_TEMP_LOW,   MUXM

    in   R_TEMP_HIGH,  ADMUX
    andi R_TEMP_HIGH,  ~MUXM
    or   R_TEMP_LOW,   R_TEMP_HIGH

    out  ADMUX,        R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRun
 ADCaptureRun:

; move parameter stack pointer into Z
    movw R_ZP_LOW,     R_PARAM_LOW

; load 2nd parameter (w_buffer_size) into R_COUNT
    ld R_COUNT_LOW,    Z+
    ld R_COUNT_HIGH,   Z+

; load 1st parameter (p_buffer) into X
    ld   R_XP_LOW,     Z+
    ld   R_XP_HIGH,    Z

; clear Free Running mode
    cbi ADCSRA,        ADFR

; clear ADC interrupt flag
    cbi ADCSRA,        ADIE

; set ADC Enable
    sbi ADCSRA,        ADEN

 AD_CAPTURE_RUN_LOOP:

; set Start Conversion
    sbi  ADCSRA,       ADSC

 AD_CAPTURE_RUN_WAIT:
    sbic ADCSRA,       ADSC
    rjmp AD_CAPTURE_RUN_WAIT

; load ADC value in R_TEMP
    in   R_TEMP_LOW,   ADCL
    in   R_TEMP_HIGH,  ADCH

; store the values in the word array
    st   X+,           R_TEMP_LOW
    st   X+,           R_TEMP_HIGH

; repeat ADC loop if R_COUNT is not zero
    sbiw R_COUNT_LOW,  1
    brne AD_CAPTURE_RUN_LOOP

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRunFree
 ADCaptureRunFree:

; move parameter stack pointer into Z
    movw R_ZP_LOW,     R_PARAM_LOW

; load 2nd parameter (w_buffer_size) into R_COUNT
    ld   R_COUNT_LOW,  Z+
    ld   R_COUNT_HIGH, Z+

; load 1st parameter (p_buffer) into X
    ld   R_XP_LOW,     Z+
    ld   R_XP_HIGH,    Z

    in   R_DATA_LOW,   SREG
; clear global interrupt flag
    cli

; set Free Running mode
    sbi  ADCSRA,       ADFR

; set ADC Enable
    sbi  ADCSRA,       ADEN

; set Start Conversion
    sbi  ADCSRA,       ADSC

 AD_CAPTURE_RUN_FREE_LOOP:

 AD_CAPTURE_RUN_FREE_WAIT:
    sbis ADCSRA,       ADIF
    rjmp AD_CAPTURE_RUN_FREE_WAIT

; clear ADC interrupt flag
    sbi  ADCSRA,       ADIF

; load ADC value in R_TEMP
    in   R_TEMP_LOW,   ADCL
    in   R_TEMP_HIGH,  ADCH

; store the value in the word array
    st   X+,           R_TEMP_LOW
    st   X+,           R_TEMP_HIGH

; repeat ADC loop if R_COUNT is not zero
    sbiw R_COUNT_LOW,  1
    brne AD_CAPTURE_RUN_FREE_LOOP

; restore status register
    out  SREG,         R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRunQuiet
 ADCaptureRunQuiet:

; move parameter stack pointer into Z
    movw R_ZP_LOW,     R_PARAM_LOW

; load 2nd parameter (w_buffer_size) into R_COUNT
    ld   R_COUNT_LOW,  Z+
    ld   R_COUNT_HIGH, Z+

; load 1st parameter (p_buffer) into X
    ld   R_XP_LOW,     Z+
    ld   R_XP_HIGH,    Z

    in   R_DATA_LOW,   SREG
    sei

; clear Free Running mode
    cbi  ADCSRA,       ADFR

; set ADC Enable
    sbi  ADCSRA,       ADEN

; set ADC Interrupt Enable
    sbi  ADCSRA,       ADIE

; enable sleep mode
    ldi  R_ZP_LOW,     (1 << SE) | (1 << SM0)
    in   R_ZP_HIGH,    MCUCR
    or   R_ZP_LOW,     R_ZP_HIGH
    out  MCUCR,        R_ZP_LOW

 AD_CAPTURE_RUN_QUIET_LOOP:

; set Start Conversion
    sbi  ADCSRA,       ADSC

; Enter ADC Noise Reduction mode.
    sleep


; Maybe an other event woke up the cpu,
; before the conversion is complete.
 AD_CAPTURE_RUN_QUIET_WAIT:
    sbic ADCSRA,       ADSC
    rjmp AD_CAPTURE_RUN_QUIET_WAIT

; load ADC value in R_TEMP
    in   R_TEMP_LOW,   ADCL
    in   R_TEMP_HIGH,  ADCH

; store the value in the word array
    st   X+,           R_TEMP_LOW
    st   X+,           R_TEMP_HIGH

; repeat ADC loop if R_COUNT is not zero
    sbiw R_COUNT_LOW,  1
    brne AD_CAPTURE_RUN_QUIET_LOOP

    out  MCUCR,        R_ZP_HIGH
; restore status register
    out  SREG,         R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRunFreeFloat
 ADCaptureRunFreeFloat:

; move parameter stack pointer into Z
    movw R_ZP_LOW,     R_PARAM_LOW

; load 2nd parameter (w_buffer_size) into R_COUNT
    ld   R_COUNT_LOW,  Z+
    ld   R_COUNT_HIGH, Z+

; load 1st parameter (p_buffer) into X
    ld   R_XP_LOW,     Z+
    ld   R_XP_HIGH,    Z

    in   R_DATA_LOW,   SREG
; clear global interrupt flag
    cli

; set Free Running mode
    sbi  ADCSRA,       ADFR

; set ADC Enable
    sbi  ADCSRA,       ADEN

; set Start Conversion
    sbi  ADCSRA,       ADSC

 AD_CAPTURE_RUN_FREE_FLOAT_LOOP:

 AD_CAPTURE_RUN_FREE_FLOAT_WAIT:
    sbis ADCSRA,       ADIF
    rjmp AD_CAPTURE_RUN_FREE_FLOAT_WAIT

; clear ADC interrupt flag
    sbi  ADCSRA,       ADIF

; load ADC value in R_TEMP
    in   R_TEMP_LOW,   ADCL
    in   R_TEMP_HIGH,  ADCH

; Conversion of 12 bit ADC value (in 16 bit register) to 32 bit float.
; The 32 bits float consists of 1 sign bit + 8 bits exponent + 23 bits
; The ADC value sign is always positive therefore is the sign = 0.
; bias = 127
; max. loops = 16
; 0x10|16 + 0x7F|127 = 0x8F|143
; set starting value of the exponent to 143
    ldi  R_ZP_LOW,     0x8F

; set max loops
    ldi  R_ZP_HIGH,    0x10

 AD_CAPTURE_FIND_EXPONENT:

; decrease exponent with 1
    dec  R_ZP_LOW

; shift left low byte of ADC value
    lsl  R_TEMP_LOW

; rotate left high byte of ADC value
    rol  R_TEMP_HIGH

; branch if carry set
    brcs AD_CAPTURE_EXPONENT_FOUND

    dec  R_ZP_HIGH
    brne AD_CAPTURE_FIND_EXPONENT

; in the case the value is zero
    clr  R_ZP_LOW
    rjmp AD_CAPTURE_STORE_VALUE

 AD_CAPTURE_EXPONENT_FOUND:
    lsr  R_ZP_LOW
    ror  R_TEMP_HIGH
    ror  R_TEMP_LOW

; store the value in the float array
 AD_CAPTURE_STORE_VALUE:
    clr  R_DATA_HIGH
    st   X+,           R_DATA_HIGH
    st   X+,           R_TEMP_LOW
    st   X+,           R_TEMP_HIGH
    st   X+,           R_ZP_LOW

; repeat ADC loop if R_COUNT is not zero
    sbiw R_COUNT_LOW,  1
    brne AD_CAPTURE_RUN_FREE_FLOAT_LOOP


; restore status register
    out  SREG,         R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRelease
 ADCaptureRelease:

; clear ADC Enable
    cbi  ADCSRA,       ADEN

; clear ADC Interrupt Enable
    cbi  ADCSRA,       ADIE

    ret
 .endif
;-------------------------------------------------