/*** ADCapture-0.02.cc ***/
//------------------------------------------------
 #if MEGA32 || MEGA128 || AVR32

// 14745600 Hz / 128 = 115200 Hz = 115.2 kHz
 #define ADC_FRQ_115 7
// 115200 Hz / 13 = 8861 Hz
 #define ADC_SAMPLE_8861 7

// 14745600 Hz / 64 = 230400 Hz = 230.4 kHz
 #define ADC_FRQ_230 6
// 230400 Hz / 13 = 17723 Hz
 #define ADC_SAMPLE_17723 6

 #endif

 #if MEGA128CAN

// 16000000 Hz / 128 = 125000 Hz = 125 kHz
 #define ADC_FRQ_125 7
// 125000 Hz / 13 = 9615 Hz
 #define ADC_SAMPLE_9615 7

// 16000000 Hz / 64 = 250000 Hz = 250 kHz
 #define ADC_FRQ_250 6
// 250000 Hz / 13 = 19230 Hz
 #define ADC_SAMPLE_19230 6

 #endif
//------------------------------------------------
 void ADCaptureSetVref      $asm("TagADCaptureSetVREF")      (byte by_vref);
 void ADCaptureSetPrescaler $asm("TagADCaptureSetPrescaler") (byte by_prescaler);
 void ADCaptureeetChannel   $asm("TagADCaptureSetChannel")   (byte by_channel);

// Use ADCaptureRun(...)
// when your project contains time-critical interrupt functions.
 void ADCaptureRun     $asm("TagADCaptureRun") (word p_buffer[], word w_count);

// Use ADCaptureRunFree(...)
// when you need a precise sampling rate.
 void ADCaptureRunFree $asm("TagADCaptureRunFree") (word p_buffer[], word w_count);

 void ADCaptureRelease $asm("TagADCaptureRelease") (void);
//------------------------------------------------
 void ADCaptureInit(
    byte by_vref,
    byte by_prescaler,
    byte by_channel
    )
    {
    ADCaptureSetVref(by_vref);
    ADCaptureSetPrescaler(by_prescaler);
    ADCaptureSetChannel(by_channel);
    }
//------------------------------------------------