/*** running_eggs-0.01.cc ***/
//------------------------------------------------
/*** Define Portbits ***/
 #define PORT_LB_A1 16
 #define PORT_LB_A2 17
 #define PORT_LB_A3 18
 #define PORT_LB_B1 19
 #define PORT_LB_B2 20
 #define PORT_LB_B3 21
 #define LB_COUNT   6
 #define PORT_RESET_CB_A 22
 #define PORT_RESET_CB_B 23
 #define PORT_CB_A  8
 #define PORT_CB_B  9
 #define CB_COUNT   2

/*** Define Light Barrier States ***/
 #define LB_STATE_CONFIRM 0
 #define LB_STATE_PF      1
 #define LB_STATE_NF      2

/*** Define Conveyor Belt States ***/
 #define CB_STATE_RUN      0
 #define CB_STATE_STOP     1

/*** Define Conveyor Belt Index ***/
 #define CB_A 0
 #define CB_B 1

/*** Define Light Barrier Index ***/
 #define LB_A1 0
 #define LB_A2 1
 #define LB_A3 2
 #define LB_B1 3
 #define LB_B2 4
 #define LB_B3 5

/*** Define Processing States ***/
 #define WAIT_FOR_EGG     1
 #define CHECK_IS_FREE    2
 #define WAIT_FOR_CONFIRM 3
 #define WAIT_FOR_RESET   4

//------------------------------------------------
/*** Define Global Variables ***/
 word gaw_count_down_lb[LB_COUNT];
 byte gaby_lb_state[LB_COUNT];
 byte gaby_cb_state[CB_COUNT];
 byte gaby_process_state[CB_COUNT];

//------------------------------------------------
/*** Define Event Handling ***/
 void OnWaitForEgg(byte by_cb)
    {
    switch(by_cb)
        {
        case CB_A:
            if(LB_STATE_PF == gaby_lb_state[LB_A1])
                {
                gaby_lb_state[LB_A1] = LB_STATE_CONFIRM;
                gaby_process_state[CB_A] = CHECK_IS_FREE;
                }
            break;

        case CB_B:
            if(LB_STATE_PF == gaby_lb_state[LB_B1])
                {
                gaby_lb_state[LB_B1] = LB_STATE_CONFIRM;
                gaby_process_state[CB_B] = CHECK_IS_FREE;
                }
            break;
        }
    }
//------------------------------------------------
 void OnCheckIsFree(byte by_cb)
    {
    switch(by_cb)
        {
        case CB_A:
            if(gaw_count_down_lb[LB_A3])
                gaby_cb_state[CB_A] = CB_STATE_STOP;
            else
                {
                gaby_cb_state[CB_A] = CB_STATE_RUN;
                gaby_process_state[CB_A] = WAIT_FOR_CONFIRM;
                }
            break;

        case CB_B:
            if(gaw_count_down_lb[LB_B3])
                gaby_cb_state[CB_B] = CB_STATE_STOP;
            else
                {
                gaby_cb_state[CB_B] = CB_STATE_RUN;
                gaby_process_state[CB_B] = WAIT_FOR_CONFIRM;
                }
            break;
        }
    }
//------------------------------------------------
 void OnWaitForConfirm(byte by_cb)
    {
    switch(by_cb)
        {
        case CB_A:
            switch(gaby_lb_state[LB_A1])
                {
                case LB_STATE_CONFIRM:
                    break;
                case LB_STATE_PF:
                    gaby_cb_state[CB_A] = CB_STATE_STOP;
                case LB_STATE_NF:
                    if(0 == gaw_count_down_lb[LB_A1])
                        {
                        gaby_cb_state[CB_A] = CB_STATE_STOP;
                        gaby_process_state[CB_A] = WAIT_FOR_RESET;
                        break;
                        }
                    if(gaw_count_down_lb[LB_A1] & gaw_count_down_lb[LB_A2])
                        {
                        gaby_process_state[CB_A] = WAIT_FOR_EGG;
                        break;
                        }
                }
            break;

        case CB_B:
            switch(gaby_lb_state[LB_B1])
                {
                case LB_STATE_CONFIRM:
                    break;
                case LB_STATE_PF:
                    gaby_cb_state[CB_B] = CB_STATE_STOP;
                case LB_STATE_NF:
                    if(0 == gaw_count_down_lb[LB_B1])
                        {
                        gaby_cb_state[CB_B] = CB_STATE_STOP;
                        gaby_process_state[CB_B] = WAIT_FOR_RESET;
                        break;
                        }
                    if(gaw_count_down_lb[LB_B1] & gaw_count_down_lb[LB_B2])
                        {
                        gaby_process_state[CB_B] = WAIT_FOR_EGG;
                        break;
                        }
                }
            break;
        }
    }
//------------------------------------------------
 void OnWaitForReset(byte by_cb)
    {
    switch(by_cb)
        {
        case CB_A:
            if(Port_ReadBit(PORT_RESET_CB_A))
                {
                gaby_cb_state[CB_A] = CB_STATE_RUN;
                gaby_process_state[CB_A] = WAIT_FOR_EGG;
                }
            break;

        case CB_B:
            if(Port_ReadBit(PORT_RESET_CB_B))
                {
                gaby_cb_state[CB_B] = CB_STATE_RUN;
                gaby_process_state[CB_B] = WAIT_FOR_EGG;
                }
            break;
        }
    }
//------------------------------------------------
 void IrqCountDownDelay(void)
    {
    byte by_index;

    for(by_index = 0; by_index < LB_COUNT; by_index++)
        if(gaw_count_down_lb[by_index])
            --gaw_count_down_lb[by_index];

    Irq_GetCount(INT_TIM2COMP);
    }
//------------------------------------------------
 void StatusLightBarrier(byte by_port)
    {
    static byte saby_port_old[LB_COUNT];
    static word saw_delays[LB_COUNT] =
        {
        500, // delay time T1_A
         50, //   "     "  T2_A
        800, //   "     "  T3_A
        500, //   "     "  T1_B
         50, //   "     "  T2_B
        800  //   "     "  T3_B
        };
    byte by_port_new;
    byte by_index;

    by_port_new = Port_ReadBit(by_port);
    by_index = by_port - PORT_LB_A1;
    if(by_port_new ^ saby_port_old[by_index])
        {
        saby_port_old[by_index] = by_port_new;
        if(by_port_new)
            gaby_lb_state[by_index] = LB_STATE_PF;
        else
            {
            gaw_count_down_lb[by_index] = saw_delays[by_index];
            gaby_lb_state[by_index] = LB_STATE_NF;
            }
        }
    }
//------------------------------------------------
 void ProcessConveyorBelt(byte by_cb)
    {
    switch(gaby_process_state[by_cb])
        {
        case WAIT_FOR_EGG:     OnWaitForEgg(by_cb);     break;
        case CHECK_IS_FREE:    OnCheckIsFree(by_cb);    break;
        case WAIT_FOR_CONFIRM: OnWaitForConfirm(by_cb); break;
        case WAIT_FOR_RESET:   OnWaitForReset(by_cb);   break;
        default: OnWaitForEgg(by_cb);
        }
    }
//------------------------------------------------
 void main(void)
    {
/*** Initialize Ports ***/
    Port_DataDir(PortC, PORT_IN);
    Port_DataDirBit(PORT_CB_A, PORT_OUT);
    Port_DataDirBit(PORT_CB_B, PORT_OUT);

/*** Set Initial Values ***/
    gaby_process_state[CB_A] = WAIT_FOR_EGG;
    gaby_process_state[CB_B] = WAIT_FOR_EGG;
    Port_WriteBit(PORT_CB_A, PORT_ON);
    Port_WriteBit(PORT_CB_B, PORT_ON);

/*** Start Count Down Timer ***/
    Irq_SetVect(INT_TIM2COMP, IrqCountDownDelay);

    while(1)
        {
//------------------------------------------------
/*** Get Input States ***/
        StatusLightBarrier(PORT_LB_A1);
        StatusLightBarrier(PORT_LB_A2);
        StatusLightBarrier(PORT_LB_A3);
        StatusLightBarrier(PORT_LB_B1);
        StatusLightBarrier(PORT_LB_B2);
        StatusLightBarrier(PORT_LB_B3);

//------------------------------------------------
/*** Processing The Input States ***/
    ProcessConveyorBelt(CB_A);
    ProcessConveyorBelt(CB_B);

//------------------------------------------------
/*** Set Output States ***/
    if(CB_STATE_RUN == gaby_cb_state[CB_A])
        Port_WriteBit(PORT_CB_A, PORT_ON);
    else
        Port_WriteBit(PORT_CB_A, PORT_OFF);

    if(CB_STATE_RUN == gaby_cb_state[CB_B])
        Port_WriteBit(PORT_CB_B, PORT_ON);
    else
        Port_WriteBit(PORT_CB_B, PORT_OFF);
//------------------------------------------------
        }
   }
//------------------------------------------------