/*** XMLParams.h ***/
//-----------------------------------------------
 #pragma once
 #include "ADCParams.h"
//-----------------------------------------------
 using namespace System;
 using namespace System::Text;
 using namespace System::Xml;
 using namespace System::IO;
 using namespace System::Windows::Forms;
//-----------------------------------------------
 public ref class CXMLParams
    {
    private:
        String ^ ms_xml_file_name;
        XmlDocument ^ m_doc;
    public:
        CXMLParams(void);
        CXMLParams(String ^ s_xml_file_name);
        virtual ~CXMLParams(void);
        String ^ DefaultDTD(void);
        String ^ DefaultDoc(void);
        String ^ LoadProperties(array<CADCParams ^> ^ ao_adc_params);
        void SaveProperties(array<CADCParams ^> ^ ao_adc_params);
    property String ^ PortName
        {
        String ^ get(void) { return m_doc->GetElementById("APPLICATION")->Attributes["port_name"]->Value; }
        void set(String ^ s_port_name) { m_doc->GetElementById("APPLICATION")->Attributes["port_name"]->Value = s_port_name; }
        }
    property Int32 BaudRate
        {
        Int32 get(void) { return Convert::ToInt32(m_doc->GetElementById("APPLICATION")->Attributes["baud_rate"]->Value); }
        void set(Int32 i_baud_rate) { m_doc->GetElementById("APPLICATION")->Attributes["baud_rate"]->Value = i_baud_rate.ToString(); }
        }
    property String ^ DataBase
        {
        String ^ get(void) { return m_doc->GetElementById("APPLICATION")->Attributes["data_base"]->Value; }
        void set(String ^ s_data_base) { m_doc->GetElementById("APPLICATION")->Attributes["data_base"]->Value = s_data_base; }
        }
    };
//-----------------------------------------------
