/*------------------------------------------------------------------------------
 ----- DEMO ----- DEMO ----- DEMO ----- DEMO ----- DEMO ----- DEMO ----- DEMO -
 -------------------------------------------------------------------------------
 Projektname:       IC_STEPPER.cprj
 Bentigte Libss:  IntFunc_lib.cc,
 Routinen:          I2C_BUS_STEPPER_198266.cc
 Autor:             UlliS
 Datum:             05.02.2009
 Funktion:          Ein kleines Testprogramm zum TMC222.
 -------------------------------------------------------------------------------
  Ein kleines Programm um die Funktion des TMC222 zu prfen.
  Es fhrt den Motor auf Position 10.000 (Hex &2710) und wieder zurck.

  ndern sie Irun/Ihold, wenn sich der Motor nicht dreht.
 -------------------------------------------------------------------------------
  Beim Programmstart wird der Controller initialisiert, seine aktuelle
  Position (Zhlerstand in Controller) ist 0. Die Fehlerflags werden fr ca.
  2Sek. angezeigt.

  In diesem Beispiel ist die Adresse des DRIVE-CONTROLLERS 192, der JUMPER JP1
  ist nach links gesteckt. In diesem Beispiel ist die IC-BUS Ubertragung
  berwacht.
 -----------------------------------------------------------------------------*/


//Variable Declaration
word ACTPOS, TARGETPOS, SECPOS, COUNTER, PosAct;
byte ACTPOSH, ACTPOSL, TARGETPOSH, TARGETPOSL, SECPOSH, SECPOSL, CONFIG;
byte DATA0, DATA1, DATA2, DATA3, DATA4, DATA5, DATA6, DATA7, DATA8, COMMAND;

//TMC222 General Call Adress
#define TMC222 0xC0

void main(void)
{
    //IC-INIT
    I2C_Init(I2C_100kHz); //IC Bit Rate: 100 kHz


//----------- POWER ON MESSAGE ------------------------
    INIT_MOTOR();
    RESET_POSITION();
    S1REQUEST();
    AbsDelay(2000);
    S2REQUEST();

//-----------------------------------------------------
//                START  MAIN Loop
//-----------------------------------------------------
do
 {
    TARGETPOS = 0x2710;  //Dez. 10.000 Steps

//---------------- RUN STEPPER ------------------------
    if (PosAct == TARGETPOS)
      {
       TARGETPOS=0x00;
      }
      else TARGETPOS = TARGETPOS;

    AbsDelay(2500);

    GOTO_TARGET();
    RESET_POSITION();
    S1REQUEST();

//---------- CHECK For TARGET REACHED -----------------
    LP1:
        S2REQUEST();
                if (PosAct != TARGETPOS) goto LP1;


 } while (1);
}


//-----------------------------------------------------
//              MOTOR PARAMETER SETTINGS
//-----------------------------------------------------
void INIT_MOTOR(void)
{
    I2C_Start();       //Show Datasheet To TMC222 Page 34 (6.8.9)
    I2C_Write(TMC222);
    I2C_Write(0x89);   //&H89 Sets Motor Parameters
    I2C_Write(0xFF);   //N/A
    I2C_Write(0xFF);   //N/A
    I2C_Write(0xC9);   //Irun & Ihold | Bit0 To Bit3 = Ihold // Bit4 To Bit7 = Irun
    I2C_Write(0x10);   //Vmax & Vmin  | Bit0 To Bit3 = Vmin // Bit4 To Bit7 = Vmax
    I2C_Write(0x10);   //Status | 10 = right // 0 = left   // Bit0 To Bit3 = ACC // Bit4 = Shaft // Bit5 To Bit7 = SecPos
    I2C_Write(0x00);   //SecurePos
    I2C_Write(0xE);    //Step Mode | Bit2 To Bit3 = StepMode // Bit4 = AccShape
    I2C_Stop();
}

//-----------------------------------------------------
//                   RESET POSITION
//-----------------------------------------------------
void RESET_POSITION(void)
{
    COMMAND=0x86;
    PUTCOMMAND();
}

//-----------------------------------------------------
//                     HARD STOP
//-----------------------------------------------------
void HARD_STOP(void)
{
    COMMAND=0x84;
    PUTCOMMAND();
}

//-----------------------------------------------------
//             DRIVE To SECURE POSITION
//-----------------------------------------------------
void GOTO_SECURE(void)
{
    COMMAND=0x84;
    PUTCOMMAND();
}

//-----------------------------------------------------
//                 DRIVE To TARGET
//-----------------------------------------------------
void GOTO_TARGET(void)
{
    //high And low Byte (Hex div To 4Bit)
    TARGETPOSH = TARGETPOS / 0x100;
    TARGETPOSL = TARGETPOS %0x100;

    I2C_Start();
    I2C_Write(TMC222);
    I2C_Write(0x8B);
    I2C_Write(0xFF);
    I2C_Write(0xFF);
    I2C_Write(TARGETPOSH);
    I2C_Write(TARGETPOSL);
    I2C_Stop();
}

//-----------------------------------------------------
//                 STATUS S1 REQUEST
//-----------------------------------------------------
void S1REQUEST(void)
{
    COMMAND=0x81;
    GETSTAT();
}

//-----------------------------------------------------
//                 STATUS S2 REQUEST
//-----------------------------------------------------
void S2REQUEST(void)
{
    COMMAND=0xFC;
    GETSTAT();
    ACTPOSH=DATA2;
    ACTPOSL=DATA3;
}

//-----------------------------------------------------
//                   READ STATUS
//-----------------------------------------------------
void GETSTAT(void)
{
    I2C_Start();
    I2C_Write(TMC222);
    I2C_Write(COMMAND);
    I2C_Stop();

    I2C_Start();
    I2C_Write(TMC222+1);
    DATA1 = I2C_Read_ACK();
    DATA2 = I2C_Read_ACK();
    DATA3 = I2C_Read_ACK();
    DATA4 = I2C_Read_ACK();
    DATA5 = I2C_Read_ACK();
    DATA6 = I2C_Read_ACK();
    DATA7 = I2C_Read_ACK();
    DATA8 = I2C_Read_NACK();
    I2C_Stop();
}

//-----------------------------------------------------
//               SEND COMMAND To TMC222
//-----------------------------------------------------
void PUTCOMMAND(void)
{
    I2C_Start();
    I2C_Write(TMC222);
    I2C_Write(COMMAND);
    I2C_Stop();
}

