/*** DemoExtInterrupt.cc ***/
//------------------------------------------------
// This program shows an infrared-receiver which uses
// the extern interrupt 2. The input pin for Mega128
// is pin D2 (26) and for Mega32 pin B2 (10). It
// works with NEC-pulse-distance encoded signals.
// Some TV remote controls are using this coding.
// But the function "IRControlTranslateNEC" is easy
// adjustable for other protocols or you write a
// a new function which we can add to the module.
//------------------------------------------------
// This program requires these other modules and libraries:
// 1. SetAsmDefinitions.asm
// 2. SetAsmDefinitions.cc
// 3. IRControl.asm
// 4. IRControl.cc
// 5. EventHandling.cc
/*** Please add the required files to your project! ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 void main(void)
    {

    IRControlInitV2();
    IRControlStartV2();

    while(1)
        {
        if(gbo_ir_control_success)
            {
            gbo_ir_control_success = false;

 #ifdef DEBUG
            IRControlShowBuffer();
 #endif

            if(IRControlTranslateNEC())
                EventHandling();
            else
                {
 #ifdef DEBUG
                Msg_WriteText("ERROR: faulty signal\r");
 #endif
                }

            IRControlStartV2();
            }
        }
    }
//------------------------------------------------