/*** Demo.cc ***/
//------------------------------------------------
// This program demonstrates the use of the watch dog timer.
// Before using the watch dog timer, it is recommendable
// to execute two testprograms: "Test1.cc" and
// "Test2.cc".
//-----------------------------------------------
// This program requires these other modules and libraries:
// 1. Register.def
// 2. WatchDog.asm
// 3. WatchDog.cc
/*** Please add the required files to your project! ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #define PORT_HIGH         1
 #define PORT_LOW          0
//------------------------------------------------
 void LongPeriodFunction(void)
    {

    Thread_Delay(149);

    }
//------------------------------------------------
 void UnforeseeableTime(void)
    {
    Thread_Delay((0xFF & rand()));
    }
//------------------------------------------------
 void main(void)
    {
    word w_count;

    Port_DataDirBit(PORT_LED2, PORT_OUT);
    Port_WriteBit(PORT_LED2,   PORT_LOW);
    Port_DataDirBit(PORT_LED1, PORT_OUT);
    Port_WriteBit(PORT_LED1,   PORT_LOW);

 #if MEGA128_ARCH
    if(WatchDogIsReset())
        {
        WatchDogClear();
// Here we can do something special after a Watchdog Timer Reset.
// But only on Mega128 or Mega128Can because the Mega32 always
// begins with a low reset flag. Actually there are no flags set
// in the MCUCSR-register of the Mega32. In addition the program
// on Mega128 always starts with the Watchdog-Timer-Reset flag set,
// if the IDE is connected. On a relatively new Mega128Can board
// the function goes faultless. Presumably the bootloader is the
// reason for the different behavior.

// The LED1 flashes slow during a Watchdog-Reset.
        for(w_count = 0; w_count <= 5; w_count++)
            {
            Port_ToggleBit(PORT_LED1);
            Thread_Delay(100);
            }
        }
    else
        {
// The LED1 flashes fast during a normal restart of the program.
        for(w_count = 0; w_count <= 50; w_count++)
            {
            Port_ToggleBit(PORT_LED1);
            Thread_Delay(10);
            }

        }
 #else
// The LED1 flashes fast during the start on MEGA32.
    for(w_count = 0; w_count <= 50; w_count++)
        {
        Port_ToggleBit(PORT_LED1);
        Thread_Delay(10);
        }
 #endif

// Initialize and start the watch dog timer before entering the main loop.
// Look at the prescaler definitions in the file "WatchDog.cc".

    WatchDogInit(WDT_48_MS);

    WatchDogStart();

    w_count = 1;
    while(1)
        {
// Here we can do our tasks.
        Thread_Delay(4);
        Port_ToggleBit(PORT_LED2);

// You must call the function "WatchDogReset()" after 48 ms.
        WatchDogReset();

        w_count++;

        if(!(w_count % 777))
            {
            WatchDogStop();
            UnforeseeableTime();
            WatchDogStart();
            }

        if(!(w_count % 222))
            {
            WatchDogSetTime(WDT_1536_MS);
            LongPeriodFunction();
            WatchDogSetTime(WDT_48_MS);
            }

        }
    }
//------------------------------------------------