/*** WatchDog.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
/*** Define Watchdog Timer Prescaler ***/
// The theoretical values differs very strongly from
// the virtually measured. Unfortunately I can not find
// the reason why. Maybe the hardware is unstable or
// temperature dependent. Therefore we must accept the fact,
// that no exact timing is possible.

// 12 - 15 ms
 #define WDT_12_MS   0x00

// 24 - 29 ms
 #define WDT_24_MS   0x01

// 48 - 57 ms
 #define WDT_48_MS   0x02

// 96 - 115 ms
 #define WDT_96_MS   0x03

// 192 - 228 ms
 #define WDT_192_MS  0x04

// 384 - 456 ms
 #define WDT_384_MS  0x05

// 768 - 912 ms
 #define WDT_768_MS  0x06

// 1536 - 1824 ms
 #define WDT_1536_MS 0x07

//------------------------------------------------
/*** Declare ASM Functions ***/

// Set new prescaler, disable the watchdog timer and
// clear the watchdog reset flag.
// Should be called once at the beginning of the program.
 #if MEGA32 || MEGA128
 void WatchDogInit    $asm("TagWatchDogInit")      (byte by_prescaler);
 #elif MEGA128CAN
 void WatchDogInit    $asm("TagWatchDogInit128Can")(byte by_prescaler);
 #endif

// Set new prescaler and can be called everywhere in the programm
// to set a new prescaler value.
 void WatchDogSetTime $asm("TagWatchDogSetTime")   (byte by_prescaler);

 void WatchDogStart   $asm("TagWatchDogStart")     (void);
 void WatchDogStop    $asm("TagWatchDogStop")      (void);
 void WatchDogReset   $asm("TagWatchDogReset")     (void);

// It doesn't work properly on Mega32! I don't know why?
// When the program starts again after a Watchdog-Reset,
// no Watchdog-Reset-Flag is set.
 #if MEGA128_ARCH
 byte WatchDogIsReset $asm("TagWatchDogIsReset") (void);
 #endif

// Clears the Watchdog Reset Flag in MCU Control and Status Register
 void WatchDogClear   $asm("TagWatchDogClear")   (void);

//------------------------------------------------
/*** The following functions are only for test and measurement purposes. ***/
//------------------------------------------------

 #if MEGA32
 void WatchDogResetT $asm("TagWatchDogResetT32")    (void);
 void WatchDogTest   $asm("TagWatchDogTest32")
    (byte by_watch_dog_prescaler,
     byte by_timer_prescaler,
     word w_timer_value);
 #elif MEGA128
 void WatchDogResetT $asm("TagWatchDogResetT128")   (void);
 void WatchDogTest   $asm("TagWatchDogTest128")
    (byte by_watch_dog_prescaler,
     byte by_timer1_prescaler,
     word w_timer1_value);
 #elif MEGA128CAN
 void WatchDogResetT $asm("TagWatchDogResetT128Can")(void);
 void WatchDogTest   $asm("TagWatchDogTestCan")
    (byte by_watch_dog_prescaler,
     byte by_timer1_prescaler,
     word w_timer1_value);
 #endif

// get the content of the MCU Control and Status Register
 byte GetMCUCSR       $asm("TagGetMCUCSR")       (void);

//------------------------------------------------
 void WatchDogFlagPulse(void)
    {
    byte by_mcucsr;
    byte by_count;

    Port_WriteBit(PORT_LED1, 0);
    Port_DataDirBit(PORT_LED1, PORT_OUT);
    AbsDelay(1);

    by_mcucsr = GetMCUCSR();

    for(by_count = 0; by_count < by_mcucsr; by_count++)
        {
        Port_WriteBit(PORT_LED1, 1);
        AbsDelay(1);
        Port_WriteBit(PORT_LED1, 0);
        AbsDelay(1);
        }
    }
//------------------------------------------------
