;*** WatchDog.asm ***;
;-------------------------------------------------
; Author: Torsten Knorr, create-soft@freenet.de
;*** BUGS ***;
; Maybe you'll find some. Please let me know.
; By the way I am pleased with every kind of feedback.
;-------------------------------------------------
 .include "Register.def"
;-------------------------------------------------
 .equ WDTPM  = 0x07 ; Watch Dog Timer Prescalar Mask
 .equ MCUCSR = 0x34 ; MCU Control and Status Register
 .equ MCUSR  = 0x34 ; MCU general Status Register Mega128Can
 .equ WDRF   = 0x03 ; Watchdog Reset Flag
 .equ WDP0   = 0x00 ; Watch Dog Timer Prescaler bit 0
 .equ WDP1   = 0x01 ; Watch Dog Timer Prescaler bit 1
 .equ WDP2   = 0x02 ; Watch Dog Timer Prescaler bit 2
 .equ WDE    = 0x03 ; Watch Dog Enable
 .equ WDTOE  = 0x04 ; Watchdog Change Enable
 .equ WDCE   = 0x04 ; Mega128Can
 .equ SREG   = 0x3F ; CPU Status Register
 .equ WGM12  = 3    ; Waveform Generation Mode
;-------------------------------------------------
 .ifdef TagWatchDogInit

 .equ WDTCR  = 0x21 ; Watchdog Timer Control Register

 .macro WATCH_DOG_TIMER_SET
    out   WDTCR,         @0
 .endmacro

 .macro WATCH_DOG_TIMER_GET
    in    @0,            WDTCR
 .endmacro

 WatchDogInit:

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 1st parameter (by_prescaler) into R_TEMP_LOW
    ld    R_TEMP_LOW,    Z

; mask lower 3 bits
; Only for the case, the user gives us an invalid parameter
    andi  R_TEMP_LOW,    WDTPM

; set WatchdogChangeEnable and WatchDogEnable bit in register
    ldi   R_TEMP_HIGH,   (1 << WDTOE) | (1 << WDE)

; The write access may not be interrupted
    in    R_DATA_LOW,    SREG
    cli

; enable watchdog change
    out   WDTCR,         R_TEMP_HIGH

; set new prescaler and disable Watchdog Timer
    out   WDTCR,         R_TEMP_LOW

; clear the Watchdog Reset Flag
    in    R_TEMP_LOW,    MCUCSR
    andi  R_TEMP_LOW,    ~(1 << WDRF)
    out   MCUCSR,        R_TEMP_LOW

    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogInit128Can

 .equ WDTCR = 0x60

 .macro WATCH_DOG_TIMER_SET
    sts   WDTCR,         @0
 .endmacro

 .macro WATCH_DOG_TIMER_GET
    lds   @0,            WDTCR
 .endmacro

 WatchDogInit:

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 1st parameter (by_prescaler) into R_TEMP_LOW
    ld    R_TEMP_LOW,    Z

; mask lower 3 bits
; Only for the case, the user gives us an invalid parameter
    andi  R_TEMP_LOW,    WDTPM

; set WatchdogChangeEnable and WatchDogEnable bit in register
    ldi   R_TEMP_HIGH,   (1 << WDTOE) | (1 << WDE)

; The write access may not be interrupted
    in    R_DATA_LOW,    SREG
    cli

; enable watchdog change
    sts   WDTCR,         R_TEMP_HIGH

; set new prescaler and disable Watchdog Timer
    sts   WDTCR,         R_TEMP_LOW

; clear the Watchdog Reset Flag
    in    R_TEMP_LOW,    MCUCSR
    andi  R_TEMP_LOW,    ~(1 << WDRF)
    out   MCUCSR,        R_TEMP_LOW

    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogSetTime

 WatchDogSetTime:

; reset Watchdog Timer
    wdr

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 1st parameter (by_prescaler) into R_TEMP_LOW
    ld    R_TEMP_LOW,    Z

; mask lower 3 bits
; only for the case, the user gives us an invalid parametre
    andi  R_TEMP_LOW,    WDTPM

; load WDTCR content in general purpose register
    WATCH_DOG_TIMER_GET R_TEMP_HIGH

; clear the prescaler bits in register
    andi  R_TEMP_HIGH,   ~WDTPM

; set the new prescaler bits in register
    or    R_TEMP_HIGH,   R_TEMP_LOW

; set WDTOE and WDE bit in register
    ldi   R_TEMP_LOW,    (1 << WDTOE) | (1 << WDE)

; The write access may not be interrupted
    in    R_DATA_LOW,    SREG
    cli

; enable Watchdog Timer change
    WATCH_DOG_TIMER_SET R_TEMP_LOW

; set new prescaler and the old state of WDE bit
    WATCH_DOG_TIMER_SET R_TEMP_HIGH

; reset Watchdog Timer to start new timeout
    wdr

    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogStart
 WatchDogStart:

; load WDTCR content in general purpose register
    WATCH_DOG_TIMER_GET R_TEMP_LOW

; set Watchdog Timer enable bit
    ori   R_TEMP_LOW,    (1 << WDE)

; start Watchdog Timer
    WATCH_DOG_TIMER_SET R_TEMP_LOW

; reset Watchdog Timer
    wdr

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogStop
 WatchDogStop:

; reset Watchdog Timer
    wdr

; load old WDTCR content in general purpose registrer
   WATCH_DOG_TIMER_GET R_TEMP_LOW

; clear Watchdog Timer enable bit
   andi   R_TEMP_LOW,    ~(1 << WDE)

; set WDTOE and WDE bit in register
    ldi   R_TEMP_HIGH,   (1 << WDTOE) | (1 << WDE)

; The write access may not be interrupted
    in    R_DATA_LOW,    SREG
    cli

; enable Watchdog Timer change
    WATCH_DOG_TIMER_SET R_TEMP_HIGH

; Turn off Watchdog Timer
    WATCH_DOG_TIMER_SET R_TEMP_LOW

    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogReset
 WatchDogReset:

; reset Watchdog Timer
    wdr

    ret
 .endif
;-------------------------------------------------
; It doesn't work properly on Mega32!
; When the program starts again after a Watchdog-Reset,
; no Watchdog-Reset-Flag is set.
 .ifdef TagWatchDogIsReset
 WatchDogIsReset:

; load the content of the MCUCSR
    in    R_TEMP_LOW,    MCUCSR

; extract the Watchdog Reset Flag
    andi  R_TEMP_LOW,    (1 << WDRF)

; copy stack pointer
     movw R_ZP_LOW,      R_SP_LOW

; add 4 to sp
    adiw  R_ZP_LOW,      0x04

; copy back to stack pointer location
    movw  R_SP_LOW,      R_ZP_LOW

; store byte value on stack
    st    Z+,            R_TEMP_LOW

; only for the case, the user stores the value in a bigger data type
    clr   R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z,             R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogClear
 WatchDogClear:

    in    R_TEMP_LOW,    MCUCSR

    andi  R_TEMP_LOW,    ~(1 << WDRF)

    out   MCUCSR,        R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
;*** The following functions are only for test and measurement purposes. ***;
;-------------------------------------------------
 .ifdef TagWatchDogResetT32

; LED2
 .set PORTD  = 0x12
 .set PORTD7 = 7

 WatchDogResetT:

; positive flank for the measurement
    sbi   PORTD,         PORTD7

; reset Watchdog Timer
    wdr

    cbi   PORTD,         PORTD7

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogTest32

; Watch Dog Timer Control Register
 .equ WDTCR  = 0x21

; Timer 1
 .equ TCCR1A = 0x2f
 .equ TCCR1B = 0x2e
 .equ TCNT1L = 0x2c
 .equ TCNT1H = 0x2d
 .equ OCR1AL = 0x2a
 .equ OCR1AH = 0x2b
 .equ TIFR   = 0x38
 .equ OCF1A  = 4   ; Output Compare Flag 1A

; LED2
 .set PORTD  = 0x12
 .set PORTD7 = 7

 WatchDogTest:

    in    R_DATA_LOW,    SREG
    cli

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 3rd parameter (w_timer1_value) into R_TEMP
    ld    R_TEMP_LOW,    Z+
    ld    R_TEMP_HIGH,   Z+

; load 2nd parameter (by_timer1_prescaler) into R_XP_LOW
    ld    R_XP_LOW,      Z+

; load 1st parameter (by_watch_dog_prescaler) into R_XP_HIGH
    ld    R_XP_HIGH,     Z

; Set OCR1AH and OCR1AL - Output Compare Register 1 A.
    out   OCR1AH,        R_TEMP_HIGH
    out   OCR1AL,        R_TEMP_LOW
; Set TCCR1A - Timer/Counter1 Control Register A.
    clr   R_TEMP_LOW
    out   TCCR1A,        R_TEMP_LOW
; Set TCCR1B - Timer/Counter1 Control Register B.
    ori   R_XP_LOW,      (1 << WGM12)
    out   TCCR1B,        R_XP_LOW

; set WDTOE and WDE bit in register
    ldi   R_TEMP_HIGH,   (1 << WDCE) | (1 << WDE)
; set Watchdog Timer enable bit
    ori   R_XP_HIGH,     (1 << WDE)
    wdr
    out   WDTCR,         R_TEMP_HIGH
; start Watchdog Timer
    OUT   WDTCR,         R_XP_HIGH
    wdr

    ldi   R_TEMP_LOW,    (1 << OCF1A)
    out   TIFR,          R_TEMP_LOW
    clr   R_TEMP_LOW

; positive flank for the measurement
    wdr
    sbi   PORTD,         PORTD7

; Reset Timer1
    out   TCNT1H,        R_TEMP_LOW
    out   TCNT1L,        R_TEMP_LOW
 WATCH_DOG_WAIT_TIMER1:
    in    R_TEMP_LOW,    TIFR
    sbrs  R_TEMP_LOW,    OCF1A
    rjmp  WATCH_DOG_WAIT_TIMER1

; negative flank
    cbi   PORTD,         PORTD7
    wdr

; clear Watchdog Timer enable bit
    ldi   R_TEMP_LOW,    (0 << WDE)
; enable Watchdog Timer change
    out   WDTCR,         R_TEMP_HIGH
; Turn off Watchdog Timer
    out   WDTCR,         R_TEMP_LOW

    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogResetT128

; LED2
 .set PORTG  = 0x65 ; MEMORY MAPPED
 .set PORTG4 = 4

 WatchDogResetT:

    lds   R_TEMP_LOW,    PORTG
    sbr   R_TEMP_LOW,    (1 << PORTG4)

; positive flank for the measurement
    sts   PORTG,         R_TEMP_LOW

; reset Watchdog Timer
    wdr

    cbr   R_TEMP_LOW,    (1 << PORTG4)
    sts   PORTG,         R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogTest128

; Watch Dog Timer Control Register
 .equ WDTCR  = 0x21

; Timer 1
 .equ TCCR1A = 0x2f
 .equ TCCR1B = 0x2e
 .equ TCNT1L = 0x2c
 .equ TCNT1H = 0x2d
 .equ OCR1AL = 0x2a
 .equ OCR1AH = 0x2b
 .equ TIFR   = 0x36
 .equ OCF1A  = 4

; LED2
 .set PORTG  = 0x65 ; MEMORY MAPPED
 .set PORTG4 = 4

 WatchDogTest:

    in    R_DATA_LOW,    SREG
    cli

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 3rd parameter (w_timer1_value) into R_TEMP
    ld    R_TEMP_LOW,    Z+
    ld    R_TEMP_HIGH,   Z+

; load 2nd parameter (by_timer1_prescaler) into R_XP_LOW
    ld    R_XP_LOW,      Z+

; load 1st parameter (by_watch_dog_prescaler) into R_XP_HIGH
    ld    R_XP_HIGH,     Z

; Set OCR1AH and OCR1AL - Output Compare Register 1 A.
    out   OCR1AH,        R_TEMP_HIGH
    out   OCR1AL,        R_TEMP_LOW
; Set TCCR1A - Timer/Counter1 Control Register A.
    clr   R_TEMP_LOW
    out   TCCR1A,        R_TEMP_LOW
; Set TCCR1B - Timer/Counter1 Control Register B.
    ori   R_XP_LOW,      (1 << WGM12)
    out   TCCR1B,        R_XP_LOW

; set WDTOE and WDE bit in register
    ldi   R_TEMP_HIGH,   (1 << WDCE) | (1 << WDE)
; set Watchdog Timer enable bit
    ori   R_XP_HIGH,     (1 << WDE)
    wdr
    out   WDTCR,         R_TEMP_HIGH
; start Watchdog Timer
    OUT   WDTCR,         R_XP_HIGH
    wdr

    ldi   R_TEMP_LOW,    (1 << OCF1A)
    out   TIFR,          R_TEMP_LOW
    clr   R_TEMP_LOW

    lds   R_ZP_LOW,      PORTG
    ori   R_ZP_LOW,      (1 << PORTG4)
; positive flank for the measurement
    wdr
    sts   PORTG,         R_ZP_LOW

; Reset Timer1
    out   TCNT1H,        R_TEMP_LOW
    out   TCNT1L,        R_TEMP_LOW
 WATCH_DOG_WAIT_TIMER1:
    in    R_TEMP_LOW,    TIFR
    sbrs  R_TEMP_LOW,    OCF1A
    rjmp  WATCH_DOG_WAIT_TIMER1

; negative flank
    cbr   R_ZP_LOW,      (1 << PORTG4)
    sts   PORTG,         R_ZP_LOW
    wdr

; clear Watchdog Timer enable bit
    ldi   R_TEMP_LOW,    (0 << WDE)
; enable Watchdog Timer change
    out   WDTCR,         R_TEMP_HIGH
; Turn off Watchdog Timer
    out   WDTCR,         R_TEMP_LOW

    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogResetT128Can

; LED2
 .set PORTG  = 0x14
 .set PORTG4 = 4

 WatchDogResetT:

; positive flank for the measurement
    sbi   PORTG,         PORTG4

; reset Watchdog Timer
    wdr

    cbi   PORTG,         PORTG4

    ret
 .endif
;-------------------------------------------------
 .ifdef TagWatchDogTestCan

; Watch Dog Timer Control Register
 .equ WDTCR  = 0x60

; Timer 1
 .equ OCR1AH = 0x89
 .equ OCR1AL = 0x88
 .equ TCNT1H = 0x85
 .equ TCNT1L = 0x84
 .equ TCCR1B = 0x81
 .equ TCCR1A = 0x80
 .equ TIFR1  = 0x16
 .equ OCF1A  = 1

; LED2
 .set PORTG  = 0x14
 .set PORTG4 = 4

 WatchDogTest:

    in    R_DATA_LOW,    SREG
    cli

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 3rd parameter (w_timer1_value) into R_TEMP
    ld    R_TEMP_LOW,    Z+
    ld    R_TEMP_HIGH,   Z+

; load 2nd parameter (by_timer1_prescaler) into R_XP_LOW
    ld    R_XP_LOW,      Z+

; load 1st parameter (by_watch_dog_prescaler) into R_XP_HIGH
    ld    R_XP_HIGH,     Z

; Set OCR1AH and OCR1AL - Output Compare Register 1 A.
    sts   OCR1AH,        R_TEMP_HIGH
    sts   OCR1AL,        R_TEMP_LOW
; Set TCCR1A - Timer/Counter1 Control Register A.
    clr   R_TEMP_LOW
    sts   TCCR1A,        R_TEMP_LOW
; Set TCCR1B - Timer/Counter1 Control Register B.
    ori   R_XP_LOW,      (1 << WGM12)
    sts   TCCR1B,        R_XP_LOW

; set WDTOE and WDE bit in register
    ldi   R_TEMP_HIGH,   (1 << WDCE) | (1 << WDE)
; set Watchdog Timer enable bit
    ori   R_XP_HIGH,     (1 << WDE)
    wdr
    sts   WDTCR,         R_TEMP_HIGH
; start Watchdog Timer
    sts   WDTCR,         R_XP_HIGH

    ldi   R_TEMP_LOW,    (1 << OCF1A)
    out   TIFR1,         R_TEMP_LOW
    clr   R_TEMP_LOW

; positive flank for the measurement
    wdr
    sbi   PORTG,          PORTG4

; Reset Timer1
    sts   TCNT1H,        R_TEMP_LOW
    sts   TCNT1L,        R_TEMP_LOW
 WATCH_DOG_WAIT_TIMER1:
    in    R_TEMP_LOW,    TIFR1
    sbrs  R_TEMP_LOW,    OCF1A
    rjmp  WATCH_DOG_WAIT_TIMER1

; negative flank
    cbi   PORTG,         PORTG4
    wdr

; clear Watchdog Timer enable bit
    ldi   R_TEMP_LOW,    (0 << WDE)
; enable Watchdog Timer change
    sts   WDTCR,         R_TEMP_HIGH
; Turn off Watchdog Timer
    sts   WDTCR,         R_TEMP_LOW

    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagGetMCUCSR
 GetMCUCSR:

; load the content of the MCUCSR
    in    R_TEMP_LOW,    MCUCSR

; copy stack pointer
    movw  R_ZP_LOW,      R_SP_LOW

; add 4 to sp
    adiw  R_ZP_LOW,      0x04

; copy back to stack pointer location
    movw  R_SP_LOW,      R_ZP_LOW

; store byte value on stack
    st    Z+,            R_TEMP_LOW

; only for the case, the user stores the value in a bigger data type
    clr   R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z,             R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------


