/*** ThreadDisplay.cc ***/
//------------------------------------------------
// LCD-Display
// |--------|
// |C???A???|
// |00100000|
// |--------|
// 1st line C = Commando, A = Address
// 2nd line = Data
//------------------------------------------------
 #include "main.h"
 #include "RelayCard.h"
//------------------------------------------------
 void ThreadDisplay(void)
    {
    char ac_msg[9];

    while(1)
        {
        LCD_CursorPos(0x00);
        Thread_Delay(1);
        Str_Printf(
            ac_msg,
            "C%3uA%3u",
            gaby_tx_buffer[COMMAND],
            gaby_tx_buffer[ADDRESS]
            );
        LCD_WriteText(ac_msg);
        Thread_Delay(1);

        LCD_CursorPos(0x40);
        Thread_Delay(1);
        Str_WriteWord(gaby_tx_buffer[DATA], 2, ac_msg, 0, 8);
        LCD_WriteText(ac_msg);
        Thread_Delay(1);

        switch(gby_item)
            {
            case COMMAND:
                LCD_CursorPos(0x00);
                break;
            case ADDRESS:
                LCD_CursorPos(0x04);
                break;
            case DATA:
                LCD_CursorPos(0x47);
                break;
            case SHOW_RESULT:
                LCD_CursorPos(0x00);
                Thread_Delay(1);
                LCD_WriteText("Com.Send");
                LCD_CursorPos(0x40);
                Thread_Delay(1);
                if(gbo_result)
                    LCD_WriteText("---OK---");
                else
                    LCD_WriteText("--ERROR-");
                Thread_Delay(100);
                gby_item = COMMAND;
                break;
            }
        Thread_Delay(100);
        }
    }
//------------------------------------------------