;*** BitSequence.asm ***;
;-------------------------------------------------
 .include "RegDef.inc"
;-------------------------------------------------
 .equ SREG   = 0x3f

; TCCR1A - Timer/Counter1 Control Register A
 .equ WGM10  = 0 ; Waveform Generation Mode
 .equ WGM11  = 1 ; Waveform Generation Mode
; TCCR1B - Timer/Counter1 Control Register B
 .equ CS10   = 0 ; Prescaler source of Timer/Counter 1
 .equ WGM12  = 3 ; Waveform Generation Mode
 .equ WGM13  = 4 ; Waveform Generation Mode

;-------------------------------------------------
 .macro BIT_SEQUENCE_WAIT_B
 BIT_SEQUENCE_WAIT_B:
    in    R_TEMP_LOW,    TIFR
    sbrs  R_TEMP_LOW,    OCF1B
    rjmp  BIT_SEQUENCE_WAIT_B
    out   TIFR,          R16
 .endmacro
;-------------------------------------------------
 .macro BIT_SEQUENCE_WAIT_A
 BIT_SEQUENCE_WAIT_A:
    in    R_TEMP_LOW,    TIFR
    sbrs  R_TEMP_LOW,    OCF1A
    rjmp  BIT_SEQUENCE_WAIT_A
    out   TIFR,          R17
 .endmacro
;-------------------------------------------------
 .ifdef TagBitSequenceInit32

 .equ TCCR1A      = 0x2f
 .equ TCCR1B      = 0x2e
 .equ TCNT1L      = 0x2c
 .equ TCNT1H      = 0x2d
 .equ OCR1AL      = 0x2a
 .equ OCR1AH      = 0x2b
 .equ OCR1BL      = 0x28
 .equ OCR1BH      = 0x29
 .equ TIFR        = 0x38
 .equ OCF1B       = 3
 .equ OCF1A       = 4

 .equ PORTC       = 0x15
 .equ DDRC        = 0x14
 .equ PINC        = 0x13
 .equ PORTC2      = 2 ; Port C Data Register bit 2
 .equ PORTC3      = 3 ; Port C Data Register bit 3
; PINC - Port C Input Pin
 .equ PINC2       = 2 ; Port C Input Pin bit 2
; DDRC - Port C Data Direction Register
 .equ DDC2        = 2 ; Port C Data Direction Register bit 2
 .equ DDC3        = 3 ; Port C Data Direction Register bit 3
 .equ PORT_TX     = PORTC
 .equ PORT_TX_BIT = PORTC3
 .equ PIN_RX      = PINC
 .equ PIN_RX_BIT  = PINC2

 .macro BIT_SEQUENCE_SET_BYTE
    out   @0,            @1
 .endmacro

 .macro BIT_SEQUENCE_SET_WORD
    out   @0,            @2
    out   @1,            @3
 .endmacro

 BitSequenceInit:

    cbi   DDRC,          DDC2
    sbi   DDRC,          DDC3

    sbi   PORT_TX,       PORTC2
    sbi   PORT_TX,       PORT_TX_BIT

    ret
 .endif
;-------------------------------------------------
 .ifdef TagBitSequenceInit128

 .equ TCCR1A      = 0x2f
 .equ TCCR1B      = 0x2e
 .equ TCNT1L      = 0x2c
 .equ TCNT1H      = 0x2d
 .equ OCR1AL      = 0x2a
 .equ OCR1AH      = 0x2b
 .equ OCR1BL      = 0x28
 .equ OCR1BH      = 0x29
 .equ TIFR        = 0x36
 .equ OCF1B       = 3
 .equ OCF1A       = 4

 .equ PORTE       = 0x03
 .equ DDRE        = 0x02
 .equ PINE        = 0x01
 .equ PINE2       = 2
 .equ PORTE2      = 2
 .equ PORTE3      = 3
 .equ DDE2        = 2
 .equ DDE3        = 3
 .equ PORT_TX     = PORTE
 .equ PORT_TX_BIT = PORTE3
 .equ PIN_RX      = PINE
 .equ PIN_RX_BIT  = PINE2

 .macro BIT_SEQUENCE_SET_BYTE
    out   @0,            @1
 .endmacro

 .macro BIT_SEQUENCE_SET_WORD
    out   @0,            @2
    out   @1,            @3
 .endmacro

 BitSequenceInit:

    cbi   DDRE,          DDE2
    sbi   DDRE,          DDE3

    sbi   PORT_TX,       PORTE2
    sbi   PORT_TX,       PORT_TX_BIT

    ret
 .endif
;-------------------------------------------------
 .ifdef TagBitSequenceInit128Can

 .equ OCR1BH      = 0x8B
 .equ OCR1BL      = 0x8A
 .equ OCR1AH      = 0x89
 .equ OCR1AL      = 0x88
 .equ ICR1H       = 0x87
 .equ ICR1L       = 0x86
 .equ TCNT1H      = 0x85
 .equ TCNT1L      = 0x84
 .equ TCCR1C      = 0x82
 .equ TCCR1B      = 0x81
 .equ TCCR1A      = 0x80
 .equ OCF1B       = 2
 .equ OCF1A       = 1
 .equ TIFR1       = 0x16
 .equ TIFR        = TIFR1

 .equ PORTE       = 0x0E
 .equ DDRE        = 0x0D
 .equ PINE        = 0x0C
 .equ PINE2       = 2
 .equ PORTE2      = 2
 .equ PORTE3      = 3
 .equ DDE2        = 2
 .equ DDE3        = 3
 .equ PORT_TX     = PORTE
 .equ PORT_TX_BIT = PORTE3
 .equ PIN_RX      = PINE
 .equ PIN_RX_BIT  = PINE2

 .macro BIT_SEQUENCE_SET_BYTE
    sts   @0,            @1
 .endmacro

 .macro BIT_SEQUENCE_SET_WORD
    sts   @0,            @2
    sts   @1,            @3
 .endmacro

 BitSequenceInit:

    cbi   DDRE,          DDE2
    sbi   DDRE,          DDE3

    sbi   PORT_TX,       PORTE2
    sbi   PORT_TX,       PORT_TX_BIT

    ret
 .endif
;-------------------------------------------------
 .ifdef TagStartTimer1
 StartTimer1:

    in    R_DATA_LOW,    SREG
    cli

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 1st parameter (w_baudrate) into R_TEMP
    ld    R_TEMP_LOW,    Z+
    ld    R_TEMP_HIGH,   Z

; Set OCR1AH and OCR1AL - Output Compare Register 1 A.
    BIT_SEQUENCE_SET_WORD OCR1AH, OCR1AL, R_TEMP_HIGH, R_TEMP_LOW

    asr   R_TEMP_HIGH
    ror   R_TEMP_LOW
; Set OCR1BH and OCR1BL - Output Compare Register 1 B.
    BIT_SEQUENCE_SET_WORD OCR1BH, OCR1BL, R_TEMP_HIGH, R_TEMP_LOW

; Set TCCR1A - Timer/Counter1 Control Register A.
    ldi   R_TEMP_LOW,    (1 << WGM10) | (1 << WGM11)
    BIT_SEQUENCE_SET_BYTE TCCR1A, R_TEMP_LOW

; Set TCCR1B - Timer/Counter1 Control Register B.
    ldi   R_TEMP_LOW,    (1 << WGM12) | (1 << WGM13) | (1 << CS10)
    BIT_SEQUENCE_SET_BYTE TCCR1B, R_TEMP_LOW

    out   SREG,          R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagBitSequenceSend
 BitSequenceSend:

    push  R2
    push  R3
    push  R4
    push  R5
    push  R8
    push  R9
    push  R16
    push  R17

    in    R_DATA_LOW,    SREG
    cli

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 5th parameter (w_time_out) into R8:R9
    ld    R8,            Z+
    ld    R9,            Z+

; load 4th parameter (w_bytes_to_receive) into R2:R3
    ld    R2,            Z+
    ld    R3,            Z+

; load 3rd parameter (p_receive_buffer) into R4:R5
    ld    R4,            Z+
    ld    R5,            Z+

; load 2nd parameter (w_bytes_to transmit) into R_COUNT
    ld    R_COUNT_LOW,   Z+
    ld    R_COUNT_HIGH,  Z+

; load 1st parameter (p_transmit_buffer) into X
    ld    R_XP_LOW,      Z+
    ld    R_XP_HIGH,     Z

    ldi   R16,           (1 << OCF1B)
    ldi   R17,           (1 << OCF1A)

    clr   R_TEMP_LOW
    BIT_SEQUENCE_SET_WORD TCNT1H, TCNT1L, R_TEMP_LOW, R_TEMP_LOW

    out   TIFR,          R16
    out   TIFR,          R17

    BIT_SEQUENCE_WAIT_B
    BIT_SEQUENCE_WAIT_A

    nop
    nop
    nop
    nop

 BIT_SEQUENCE_TRANSMIT_BYTES:

; send start bit
    cbi   PORT_TX,       PORT_TX_BIT

; load byte to send
    ld    R_DATA_HIGH,   X+

; set bitmask
    ldi   R_ZP_LOW,      1

 BIT_SEQUENCE_TRANSMIT_BITS:
    mov   R_TEMP_HIGH,   R_DATA_HIGH

    BIT_SEQUENCE_WAIT_B
    BIT_SEQUENCE_WAIT_A

; Z is set     if the result is 0    = bit LOW
; Z id cleared if the result is != 0 = bit HIGH = jump
    and   R_TEMP_HIGH,   R_ZP_LOW ; 1 cycle

; Test the Zero flag (Z) and branches if Z is cleared.
; Cycles:
;   1 if condition is false
;   2 if condition is true = jump
    brne  BIT_SEQUENCE_SET_BIT    ; 1 or 2 cycle

    nop
    nop

    cbi   PORT_TX,       PORT_TX_BIT
    rjmp  BIT_SEQUENCE_NEXT_BIT   ; 2 cycle

 BIT_SEQUENCE_SET_BIT:
    sbi   PORT_TX,      PORT_TX_BIT

 BIT_SEQUENCE_NEXT_BIT:

; repeat BIT_SEQUENCE_TRANSMIT_BITS if R_ZP_LOW is not zero
    lsl   R_ZP_LOW
    brne  BIT_SEQUENCE_TRANSMIT_BITS

    BIT_SEQUENCE_WAIT_B
    BIT_SEQUENCE_WAIT_A

    nop
    nop
    nop
    nop

; send stop bit
    sbi   PORT_TX,       PORT_TX_BIT

    BIT_SEQUENCE_WAIT_B
    BIT_SEQUENCE_WAIT_A

; repeat BIT_SEQUENCE_TRANSMIT_BYTES if R_COUNT is not zero
    sbiw  R_COUNT_LOW,   1            ; 2 cycles
    brne  BIT_SEQUENCE_TRANSMIT_BYTES ; 1 Cycles if condition is false
                                      ; 2 if condition is true
    nop

    movw  R_COUNT_LOW,   R2
    movw  R_XP_LOW,      R4

 BIT_SEQUENCE_RECEIVE_BYTES:

; set time out
    movw  R_ZP_LOW,      R8
    clr   R_TEMP_LOW

; wait for start bit
 BIT_SEQUENCE_WAIT_FOR_START_BIT:

; check time out
    sbiw  R_ZP_LOW,      1
    breq  BIT_SEQUENCE_TIME_OUT

    sbic  PIN_RX,        PIN_RX_BIT
    rjmp  BIT_SEQUENCE_WAIT_FOR_START_BIT

; start bit recognized
    BIT_SEQUENCE_SET_WORD TCNT1H, TCNT1L, R_TEMP_LOW, R_TEMP_LOW
    out   TIFR,          R16
    out   TIFR,          R17

    BIT_SEQUENCE_WAIT_B
    BIT_SEQUENCE_WAIT_A

; set bitmask
    ldi   R_TEMP_HIGH,   1
    clr   R_DATA_HIGH

 BIT_SEQUENCE_RECEIVE_BITS:

    BIT_SEQUENCE_WAIT_B

; read bit
    sbic  PIN_RX,        PIN_RX_BIT
    or    R_DATA_HIGH,   R_TEMP_HIGH

    BIT_SEQUENCE_WAIT_A

; repeat BIT_SEQUENCE_RECEIVE_BITS if R_TEMP_HIGH is not zero
    lsl   R_TEMP_HIGH
    brne  BIT_SEQUENCE_RECEIVE_BITS

; store value
    st    X+,            R_DATA_HIGH

; stop bit
    BIT_SEQUENCE_WAIT_B
    ;BIT_SEQUENCE_WAIT_A

; repeat BIT_SEQUENCE_RECEIVE_BYTES if R_COUNT is not zero
    sbiw  R_COUNT_LOW,   1
    brne  BIT_SEQUENCE_RECEIVE_BYTES

 BIT_SEQUENCE_TIME_OUT:

    out   SREG,          R_DATA_LOW
    pop   R17
    pop   R16
    pop   R9
    pop   R8
    pop   R5
    pop   R4
    pop   R3
    pop   R2
    ret
 .endif
;-------------------------------------------------

