/*** ADCapture.h ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #ifndef __AD_CAPTURE__
 #define __AD_CAPTURE__

 #define SET true
 #define GET false

 #if MEGA32 || MEGA128 || AVR32

// 14745600 Hz / 128 = 115200 Hz = 115.2 kHz
 #define ADC_FRQ_115kHz 7

// 14745600 Hz / 64 = 230400 Hz = 230.4 kHz
 #define ADC_FRQ_230kHz 6

// 14745600 Hz / 32 = 460800 Hz = 460.8 kHz
 #define ADC_FRQ_460kHz 5

// 14745600 Hz / 16 = 921600 Hz = 921.6 kHz
 #define ADC_FRQ_921kHz 4

// 14745600 Hz / 8  = 1843200 Hz = 1.8 MHz
 #define ADC_FRQ_1_8MHz 3

 #endif

 #if MEGA128CAN

// 16000000 Hz / 128 = 125000 Hz = 125 kHz
 #define ADC_FRQ_125kHz 7

// 16000000 Hz / 64 = 250000 Hz = 250 kHz
 #define ADC_FRQ_250kHz 6

 #endif
//------------------------------------------------
 #endif // __AD_CAPTURE__
//------------------------------------------------