/*** DemoDS18S20ViaDS2482.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
// This program requires these other modules and libraries:
// 1. I2C.h / I2C.cc / I2C.asm
// 2. DS18S20.h / DS18S20.cc
// 3. DS2482.h / DS2482.cc
/*** Please add the required files to your porject! ***/
//------------------------------------------------
 void main(void)
    {
    char ac_msg[40];
    float f_temperature;

    I2CInitialize(I2C_100kHz, 0x00);

    if(ConvInit(CONV_WRITE_ADDR_1))
        Msg_WriteText("Converter 1 -> OK\r");
    else
        Msg_WriteText("Converter 1 -> ERROR\r");

    if(ConvInit(CONV_WRITE_ADDR_2))
        Msg_WriteText("Converter 2 -> OK\r");
    else
        Msg_WriteText("Converter 2 -> ERROR\r");

    ConvSendValue(CONV_WRITE_ADDR_1, 1);
    ConvSendValue(CONV_WRITE_ADDR_2, 2);
    Thread_Delay(500);

    while(1)
        {
        f_temperature = ConvRead(CONV_WRITE_ADDR_1);
        if(INVALID_VALUE != f_temperature)
            {
            Str_Printf(ac_msg, "Wassertemperatur: %5.2f C\r", f_temperature);
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText("Wassertemperatur: Fehler\r");
            ConvInit(CONV_WRITE_ADDR_1);
            }

        f_temperature = ConvRead(CONV_WRITE_ADDR_2);
        if(INVALID_VALUE != f_temperature)
            {
            Str_Printf(ac_msg, "Bodentemperatur : %5.2f C\r", f_temperature);
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText("Bodentemperatur : Fehler\r");
            ConvInit(CONV_WRITE_ADDR_2);
            }

        if(I2CErrorsCount(GET))
            {
            Msg_WriteText("Errors count: ");
            Msg_WriteWord(I2CErrorsCount(GET));
            Msg_WriteChar(13);
            }

        Msg_WriteChar(13);
        Thread_Delay(100);
        }

    }
//------------------------------------------------