/*** DS2482.h ***/
//-----------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
 #ifndef __DALLAS_SEMICONDUCTOR_DS2482__
 #define __DALLAS_SEMICONDUCTOR_DS2482__
//-----------------------------------------------
 #define BOOL int
 #define INVALID_VALUE 210.0
 #define DS18S20_MAX_VALUE 101.0
 #define DS18S20_MIN_VALUE -56.0

/*** I2C address ***/
// A1 = 0; A0 = 0;         0b0011 0000
 #define CONV_WRITE_ADDR_1 0x30
// A1 = 0; A0 = 1;         0b0011 0010
 #define CONV_WRITE_ADDR_2 0x32
// A1 = 1; A0 = 0;         0b0011 0100
 #define CONV_WRITE_ADDR_3 0x34
// A1 = 1; A0 = 1;         0b0011 0110
 #define CONV_WRITE_ADDR_4 0x36

/*** Status Register ***/
// bit_7 bit_6 bit_5 bit_4 bit_3 bit_2 bit_1 bit_0
// DIR   TSB   SBR   RST   LL    SD    PPD   1WB
// DIR = Branch Direction taken
// TSB = Triplet Second Bit
// SBR = Single Bit Result

// RST = Device Reset
 #define BIT_DEVICE_RESET 4

// LL  = Logic Level
 #define BIT_LOGIC_LEVEL 3

// SD  = Short Detected
 #define BIT_SHORT_DETECT 2

// PPD = Presence-Pulse Detect
 #define BIT_PRESENCE_DETECT 1

// 1WB = 1-Wire Busy
 #define BIT_WIRE_BUSY 0

/*** Configuration Register ***/
// bit_7 bit_6 bit_5 bit_4 bit_3 bit_2 bit_1 bit_0
// 1WS   SPU   PPM   APU   1WS   SPU   PPM   APU

// 1WS = 1-Wire Speed
 #define BIT_1WS 3

// SPU = Strong Pullup
 #define BIT_SPU 2

// PPM = Presence-Pulse Masking
 #define BIT_PPM 1

// APU = Active Pullup
 #define BIT_APU 0

/*** Valid Pointer Codes ***/

// Status Register F0h
 #define CONV_STATUS_REG 0xF0

// Read Data Register E1h
 #define CONV_DATA_REG 0xE1

// Configuration Register C3h
 #define CONV_CONFIG_REG 0xC3

/*** Converter Commandos ***/

 #define CONV_RESET            0xF0
 #define CONV_OW_RESET         0xB4
 #define CONV_CONFIG           0xD2
 #define CONV_SET_READ_POINTER 0xE1
 #define CONV_WRITE_BYTE       0xA5
 #define CONV_READ_BYTE        0x96

//-----------------------------------------------
 #endif
//-----------------------------------------------