/*** Pressure.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #include "Pressure.h"
//------------------------------------------------
 float PressureRead(byte by_write_addr)
    {
    byte aby_data[2];
    byte by_read_addr;
    word w_pressure;
    float f_pressure;

    by_read_addr = by_write_addr + 1;
    aby_data[0] = 0x00;
    aby_data[1] = 0x00;
    if(!I2CReceiveData(by_read_addr, aby_data, 2, false))
        return INVALID_VALUE;

    if(0x80 & aby_data[0])
        return INVALID_VALUE;

    w_pressure = aby_data[0];
    w_pressure = w_pressure << 8;
    w_pressure = w_pressure | aby_data[1];
    f_pressure = w_pressure;
    f_pressure = f_pressure * PRESSURE_FACTOR;

    if((PRESSURE_MIN_VALUE < f_pressure) && (PRESSURE_MAX_VALUE > f_pressure))
        return f_pressure;

    return INVALID_VALUE;
    }
//------------------------------------------------
 void PressureSendValues(byte by_write_addr, int i_device_number)
    {
    char ac_msg[30];
    float f_pressure;

    f_pressure = PressureRead(by_write_addr);
    if(INVALID_VALUE != f_pressure)
        Str_Printf(ac_msg, "%d. Pressure: %5.2f kPa\r", i_device_number, f_pressure);
    else
        Str_Printf(ac_msg, "%d. Pressure: ERROR\r", i_device_number);
    Msg_WriteText(ac_msg);
    }
//------------------------------------------------