;*** I2C.asm ***;
;-------------------------------------------------
; Author: Torsten Knorr, create-soft@freenet.de
;*** BUGS ***;
; Maybe you'll find some. Please let me know.
; By the way I am pleased with every kind of feedback.
;-------------------------------------------------
 .def R_DATA_LOW   = R0
 .def R_DATA_HIGH  = R1
 .def R_SP_LOW     = R6
 .def R_SP_HIGH    = R7
 .def R_PARAM_LOW  = R10
 .def R_PARAM_HIGH = R11
 .def R_TEMP_LOW   = R22
 .def R_TEMP_HIGH  = R23
 .def R_COUNT_LOW  = R24
 .def R_COUNT_HIGH = R25
 .def R_XP_LOW     = R26
 .def R_XP_HIGH    = R27
 .def R_ZP_LOW     = R30
 .def R_ZP_HIGH    = R31
;-------------------------------------------------
; .equ TWI_BIT_RATE  = 0xFF ; (10 ... 255)
; .equ TWI_PRESCALER = 0x03 ; (0 = 1), (1 = 4), (2 = 16), (3 = 64)

;*** TWCR - TWI Control Register ***;
 .equ TWIE  = 0 ; TWI Interrupt Enable
 .equ TWEN  = 2 ; TWI Enable Bit
 .equ TWWC  = 3 ; TWI Write Collition Flag
 .equ TWSTO = 4 ; TWI Stop Condition Bit
 .equ TWSTA = 5 ; TWI Start Condition Bit
 .equ TWEA  = 6 ; TWI Enable Acknowledge Bit
 .equ TWINT = 7 ; TWI Interrupt Flag

;*** TWSR - TWI Status Register ***;
 .equ TWPS0 = 0 ; TWI Prescaler Bit 0
 .equ TWPS1 = 1 ; TWI Prescaler Bit 1

;-------------------------------------------------
 .ifdef I2CLibMega32

 .equ TWBR = 0x00 ; Bit Rate Register
 .equ TWSR = 0x01 ; Status Register
 .equ TWAR = 0x02 ; Address Register
 .equ TWDR = 0x03 ; Address/Data Shift Register
 .equ TWCR = 0x36 ; Control Register

;-------------------------------------------------
 I2CEnable:
    movw R_ZP_LOW, R_PARAM_LOW
; 2. Parameter = prescaler
    ld   R_TEMP_LOW,  Z+
; 1. Parameter = bit_rate
    ld   R_TEMP_HIGH, Z

    out  TWBR,        R_TEMP_HIGH
    out  TWSR,        R_TEMP_LOW
; ToDo
    clr  R_TEMP_LOW
    sbr  R_TEMP_LOW,  (1 << TWEN)
    out  TWCR,        R_TEMP_LOW

    ret
;-------------------------------------------------
 I2CDisable:

    clr R_TEMP_LOW
    out TWCR,       R_TEMP_LOW

    ret
;-------------------------------------------------
 .endif
;-------------------------------------------------
 .ifdef I2CLibMega128

 .equ TWBR = 0x70 ; Bit Rate Register
 .equ TWSR = 0x71 ; Status Register
 .equ TWAR = 0x72 ; Address Register
 .equ TWDR = 0x73 ; Address/Data Shift Register
 .equ TWCR = 0x74 ; Control Register

;-------------------------------------------------
 I2CEnable:
    movw R_ZP_LOW, R_PARAM_LOW
; 2. Parameter = prescaler
    ld   R_TEMP_LOW,  Z+
; 1. Parameter = bit_rate
    ld   R_TEMP_HIGH, Z

    sts  TWBR,        R_TEMP_HIGH
    sts  TWSR,        R_TEMP_LOW
; ToDo
    clr  R_TEMP_LOW
    sbr  R_TEMP_LOW,  (1 << TWEN)
    sts  TWCR,        R_TEMP_LOW

    ret
;-------------------------------------------------
 I2CDisable:

    clr R_TEMP_LOW
    sts TWCR,       R_TEMP_LOW

    ret
;-------------------------------------------------
 .endif
;-------------------------------------------------