/*** DCF77Time.h ***/
//------------------------------------------------
 #ifndef __DCF_77_TIME__
 #define __DCF_77_TIME__ 1
//------------------------------------------------
/*** DCF77 Time Definitions ***/
 #ifdef MEGA32
 #define NULL 0.0
// DCF Input Signal at PortD.7
 #define DCF_IN 31
 #endif
 #ifdef MEGA128
 #define NULL 0ul
// DCF Input Signal at PortF.0
 #define DCF_IN 40
 #endif
 #define BOOL int
 #define MINUTE 0
 #define HOUR 1
 #define DAY 2
 #define WEEKDAY 3
 #define MONTH 4
 #define YEAR 5
 #define DCF_SIZE 8
 #define BCD_SIZE 6
 #define VALUES_SIZE 6
 #define WEEKDAYS 8
 #define WEEKDAY_LENGTH 11
 #define MSG_LENGTH 35
 #define ERROR_MSG_LENGTH 20
 #define HI_CHAR(a) ((((a) % 100) / 10) + 0x30)
 #define LOW_CHAR(a) (((a) % 10) + 0x30)
//------------------------------------------------
/*** Thread Definitions ***/
 #define THREAD_DCF77 1
 #define SIG_DCF77 0x10
 #thread 0, 0, 10
 #thread THREAD_DCF77, 128, 10
//------------------------------------------------
 #endif
//------------------------------------------------