/*** demo.cc ***/
//------------------------------------------------
/*
 Mit dem Programm knnen Frequenzen zwischen 100-2500Hz
 ber den Chip PCF 8591 als Sinuskurven ausgegeben werden.
 Die Samplingrate ergibt sich aus der Geschwindigkeit des
 TWI-Buses und liegt bei etwa 43825 Samples in der Sekunde.
 Die Genauigkeit der erzeugten Frequenz liegt bei etwa 2%
 Abweichung. Das kann, wenn ntig, im Assembleraufruf noch
 korrigiert werden.

 void SineWaveInit(void)
    Initialisiert den TWI-Bus. Bit-Rate und Vorteiler werden gesetzt.
    Mu vor dem ersten Aufruf von SineWaveOut einmal aufgerufen werden.

 void SineWaveCalculate(byte p_buffer, word w_samples)
    Initialisiert das Array mit den Werten fr die Sinuskurve.
    1. Parameter: Ein Zeiger auf ein Byte-Array.
    2. Parameter: Die gre des Arrays.
    Das Array mu vor dem Aufruf von SineWaveOut initialisiert werden.

 byte SineWaveOut(byte p_wave, word w_samples, word w_repetitions)
    Gibt die Sinuskurve ber den Chip PCF 8591 aus.
    1. Parameter: Ein Zeiger auf ein Byte-Array welches vor dem
    Aufruf mit SineWaveCalculate initialisiert wurde.
    2. Parameter: Die gre des Arrays.
    3. Parameter: Die Anzahl von Wiederholungen der Ausgabe.
    Rckgabewert: Wenn kein Fehler aufgetreten ist wird TW_OK zurckgegeben.
*/
//------------------------------------------------
/*** Achtung! Vorsicht! ***/
//Je niedriger die Frequenz desto grer werden die Arrays!
 #define 50Hz   50   // 43825 / 50 = 876 samples per wave = 876 byte !!!
 #define 1200Hz 1200
 #define 2200Hz 2200
 #define 3000Hz 3000
//------------------------------------------------
 void Out50Hz(void)
    {
    byte aby_50Hz[SAMPLES(50Hz)];
    SineWaveCalculate(aby_50Hz, SAMPLES(50Hz));
    if(TW_OK != SineWaveOut(aby_50Hz, SAMPLES(50Hz), 50Hz))
        Msg_WriteText("ERROR: SineWaveOut 50Hz\r");
    }
//------------------------------------------------
 void Out1200Hz(void)
    {
    byte aby_1200Hz[SAMPLES(1200Hz)];
    SineWaveCalculate(aby_1200Hz, SAMPLES(1200Hz));
    if(TW_OK != SineWaveOut(aby_1200Hz, SAMPLES(1200Hz), 1200Hz))
        Msg_WriteText("ERROR: SineWaveOut 1200Hz\r");
    }
//------------------------------------------------
 void Out2200Hz(void)
    {
    byte aby_2200Hz[SAMPLES(2200Hz)];
    SineWaveCalculate(aby_2200Hz, SAMPLES(2200Hz));
    if(TW_OK != SineWaveOut(aby_2200Hz, SAMPLES(2200Hz), 2200Hz))
        Msg_WriteText("ERROR: SineWaveOut 2200Hz\r");
    }
//------------------------------------------------
 void Out3000Hz(void)
    {
    byte aby_3000Hz[SAMPLES(3000Hz)];
    SineWaveCalculate(aby_3000Hz, SAMPLES(3000Hz));
    if(TW_OK != SineWaveOut(aby_3000Hz, SAMPLES(3000Hz), 3000Hz))
        Msg_WriteText("ERROR: SineWaveOut 3000Hz\r");
    }
//------------------------------------------------
 void main(void)
    {
    SineWaveInit();
    while(1)
        {
        Out50Hz();
        Out1200Hz();
        Out2200Hz();
        Out3000Hz();
        }
    }
//------------------------------------------------